<?php

namespace App\Services;

class AITextGeneratorService
{
    private $apiKey;
    private $baseUrl;
    private $model;

    public function __construct()
    {
        $this->apiKey = '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';
        $this->baseUrl = 'https://openrouter.ai/api/v1/chat/completions';
        $this->model = 'arcee-ai/trinity-mini:free';
    }

    /**
     * Generate description for education
     */
    public function generateEducationDescription($namaSekolah, $jurusan = '', $jenjang = '', $tahunMulai = '', $tahunSelesai = '')
    {
        $prompt = $this->buildEducationPrompt($namaSekolah, $jurusan, $jenjang, $tahunMulai, $tahunSelesai);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for work experience
     */
    public function generateWorkDescription($namaPerusahaan, $posisi = '', $tahunMulai = '', $tahunSelesai = '')
    {
        $prompt = $this->buildWorkPrompt($namaPerusahaan, $posisi, $tahunMulai, $tahunSelesai);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for training
     */
    public function generateTrainingDescription($namaTraining, $penyelenggara = '', $durasi = '')
    {
        $prompt = $this->buildTrainingPrompt($namaTraining, $penyelenggara, $durasi);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for project
     */
    public function generateProjectDescription($namaProject, $teknologi = '', $tipeProject = '')
    {
        $prompt = $this->buildProjectPrompt($namaProject, $teknologi, $tipeProject);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for organization
     */
    public function generateOrganizationDescription($namaOrganisasi, $posisi = '', $bidang = '')
    {
        $prompt = $this->buildOrganizationPrompt($namaOrganisasi, $posisi, $bidang);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for certificate
     */
    public function generateCertificateDescription($namaSertifikat, $penerbit = '', $bidang = '')
    {
        $prompt = $this->buildCertificatePrompt($namaSertifikat, $penerbit, $bidang);
        return $this->callAPI($prompt);
    }

    /**
     * Generate description for activity
     */
    public function generateActivityDescription($namaAktivitas, $lokasi = '', $tipeAktivitas = '')
    {
        $prompt = $this->buildActivityPrompt($namaAktivitas, $lokasi, $tipeAktivitas);
        return $this->callAPI($prompt);
    }

    /**
     * Generate biodata profile description
     */
    public function generateBiodataProfile($namaLengkap, $pendidikan = '', $keahlian = '', $pengalaman = '')
    {
        $prompt = $this->buildBiodataPrompt($namaLengkap, $pendidikan, $keahlian, $pengalaman);
        return $this->callAPI($prompt);
    }

    /**
     * Generate biodata full description
     */
    public function generateBiodataDescription($namaLengkap, $pendidikan = '', $keahlian = '', $pengalaman = '', $minat = '')
    {
        $prompt = $this->buildBiodataFullPrompt($namaLengkap, $pendidikan, $keahlian, $pengalaman, $minat);
        return $this->callAPI($prompt);
    }

    /**
     * Expand existing text into detailed description
     */
    public function expandText($existingText, $context = 'general')
    {
        $prompt = $this->buildExpandTextPrompt($existingText, $context);
        return $this->callAPI($prompt);
    }

    private function buildEducationPrompt($namaSekolah, $jurusan, $jenjang, $tahunMulai, $tahunSelesai)
    {
        $status = empty($tahunSelesai) ? 'sedang menempuh' : 'telah lulus';
        
        return "Buatkan deskripsi singkat dan profesional untuk riwayat pendidikan dengan detail berikut:
- Nama Sekolah/Universitas: {$namaSekolah}
- Jenjang: {$jenjang}
- Jurusan: {$jurusan}
- Tahun Mulai: {$tahunMulai}
- Status: {$status}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Pengalaman belajar yang diperoleh
2. Keahlian atau kompetensi yang dikembangkan
3. Pencapaian atau hal menarik selama pendidikan
4. Relevansi dengan karir atau bidang yang diminati

Maksimal 150 kata, gunakan tone profesional namun personal.";
    }

    private function buildWorkPrompt($namaPerusahaan, $posisi, $tahunMulai, $tahunSelesai)
    {
        $status = empty($tahunSelesai) ? 'sedang bekerja' : 'telah bekerja';
        
        return "Buatkan deskripsi singkat dan profesional untuk pengalaman kerja dengan detail berikut:
- Nama Perusahaan: {$namaPerusahaan}
- Posisi: {$posisi}
- Tahun Mulai: {$tahunMulai}
- Status: {$status}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Tanggung jawab utama dalam posisi tersebut
2. Pencapaian atau kontribusi yang diberikan
3. Keahlian yang dikembangkan
4. Pengalaman berharga yang diperoleh

Maksimal 150 kata, gunakan tone profesional dan fokus pada value yang diberikan.";
    }

    private function buildTrainingPrompt($namaTraining, $penyelenggara, $durasi)
    {
        return "Buatkan deskripsi singkat dan profesional untuk pelatihan dengan detail berikut:
- Nama Pelatihan: {$namaTraining}
- Penyelenggara: {$penyelenggara}
- Durasi: {$durasi}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Materi atau topik yang dipelajari
2. Keahlian baru yang diperoleh
3. Manfaat untuk pengembangan karir
4. Aplikasi praktis dari pelatihan

Maksimal 120 kata, gunakan tone profesional dan fokus pada learning outcomes.";
    }

    private function buildProjectPrompt($namaProject, $teknologi, $tipeProject)
    {
        return "Buatkan deskripsi singkat dan profesional untuk proyek dengan detail berikut:
- Nama Proyek: {$namaProject}
- Teknologi: {$teknologi}
- Tipe Proyek: {$tipeProject}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Tujuan dan latar belakang proyek
2. Teknologi dan tools yang digunakan
3. Fitur utama atau fungsionalitas
4. Tantangan yang dihadapi dan solusinya
5. Hasil atau dampak dari proyek

Maksimal 150 kata, gunakan tone profesional dan teknis sesuai konteks.";
    }

    private function buildOrganizationPrompt($namaOrganisasi, $posisi, $bidang)
    {
        return "Buatkan deskripsi singkat dan profesional untuk pengalaman organisasi dengan detail berikut:
- Nama Organisasi: {$namaOrganisasi}
- Posisi: {$posisi}
- Bidang: {$bidang}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Peran dan tanggung jawab dalam organisasi
2. Kegiatan atau program yang dijalankan
3. Kontribusi yang diberikan
4. Soft skills yang dikembangkan
5. Dampak positif bagi organisasi atau masyarakat

Maksimal 130 kata, gunakan tone profesional dan fokus pada leadership dan teamwork.";
    }

    private function buildCertificatePrompt($namaSertifikat, $penerbit, $bidang)
    {
        return "Buatkan deskripsi singkat dan profesional untuk sertifikat dengan detail berikut:
- Nama Sertifikat: {$namaSertifikat}
- Penerbit: {$penerbit}
- Bidang: {$bidang}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Kompetensi yang divalidasi oleh sertifikat
2. Proses atau persyaratan untuk mendapatkan sertifikat
3. Relevansi dengan bidang karir
4. Manfaat untuk pengembangan profesional

Maksimal 100 kata, gunakan tone profesional dan fokus pada kredibilitas dan kompetensi.";
    }

    private function buildActivityPrompt($namaAktivitas, $lokasi, $tipeAktivitas)
    {
        return "Buatkan deskripsi singkat dan menarik untuk aktivitas dengan detail berikut:
- Nama Aktivitas: {$namaAktivitas}
- Lokasi: {$lokasi}
- Tipe Aktivitas: {$tipeAktivitas}

Buatkan deskripsi dalam bahasa Indonesia yang mencakup:
1. Tujuan atau latar belakang aktivitas
2. Kegiatan yang dilakukan
3. Pengalaman atau pembelajaran yang diperoleh
4. Dampak atau manfaat dari aktivitas

Maksimal 120 kata, gunakan tone personal namun tetap profesional.";
    }

    private function buildBiodataPrompt($namaLengkap, $pendidikan, $keahlian, $pengalaman)
    {
        return "Buatkan profil singkat yang menarik untuk biodata CV dengan detail berikut:
- Nama: {$namaLengkap}
- Pendidikan: {$pendidikan}
- Keahlian: {$keahlian}
- Pengalaman: {$pengalaman}

Buatkan profil singkat dalam bahasa Indonesia yang mencakup:
1. Latar belakang pendidikan dan bidang minat
2. Keahlian utama yang dimiliki
3. Pengalaman relevan
4. Value proposition atau keunikan diri

Maksimal 100 kata, gunakan tone profesional namun personal, cocok untuk bagian profil singkat CV.";
    }

    private function buildBiodataFullPrompt($namaLengkap, $pendidikan, $keahlian, $pengalaman, $minat)
    {
        return "Buatkan deskripsi lengkap untuk biodata CV dengan detail berikut:
- Nama: {$namaLengkap}
- Pendidikan: {$pendidikan}
- Keahlian: {$keahlian}
- Pengalaman: {$pengalaman}
- Minat: {$minat}

Buatkan deskripsi lengkap dalam bahasa Indonesia yang mencakup:
1. Latar belakang pendidikan dan perjalanan karir
2. Keahlian teknis dan soft skills
3. Pengalaman kerja dan proyek yang pernah dikerjakan
4. Minat dan passion di bidang tertentu
5. Visi dan tujuan karir ke depan
6. Kontribusi yang bisa diberikan

Maksimal 200 kata, gunakan tone profesional, komprehensif, dan meyakinkan untuk menarik perhatian recruiter.";
    }

    private function buildExpandTextPrompt($existingText, $context)
    {
        return "Kembangkan teks singkat berikut menjadi deskripsi yang lengkap, detail, dan profesional:

Teks yang akan dikembangkan: \"{$existingText}\"

Konteks: {$context}

Instruksi:
1. Baca dan pahami maksud dari teks singkat tersebut
2. Kembangkan menjadi deskripsi yang panjang dan detail (150-200 kata)
3. Gunakan bahasa Indonesia yang profesional dan menarik
4. Tambahkan detail yang relevan dan masuk akal
5. Buat deskripsi yang informatif dan engaging
6. Jaga konsistensi dengan makna asli teks

Hasil harus berupa paragraf yang lengkap dan siap digunakan untuk CV atau portfolio profesional.";
    }

    private function callAPI($prompt)
    {
        // Log the prompt for debugging
        log_message('info', 'AI API Prompt: ' . $prompt);
        
        $data = [
            'model' => $this->model,
            'messages' => [
                [
                    'role' => 'system',
                    'content' => 'Anda adalah asisten AI yang membantu membuat deskripsi profesional untuk CV dan portfolio. Berikan respons yang singkat, padat, dan relevan dalam bahasa Indonesia.'
                ],
                [
                    'role' => 'user',
                    'content' => $prompt
                ]
            ],
            'max_tokens' => 300,
            'temperature' => 0.7,
            'top_p' => 0.9
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->baseUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $this->apiKey,
            'HTTP-Referer: ' . base_url(),
            'X-Title: Portfolio AI Generator'
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        
        // Log the response for debugging
        log_message('info', 'AI API Response - HTTP Code: ' . $httpCode);
        log_message('info', 'AI API Response - Body: ' . substr($response, 0, 500));
        
        curl_close($ch);

        if ($error) {
            log_message('error', 'AI API cURL Error: ' . $error);
            return [
                'success' => false,
                'message' => 'Connection error: ' . $error
            ];
        }

        if ($httpCode !== 200) {
            log_message('error', 'AI API HTTP Error: ' . $httpCode . ' - Response: ' . $response);
            return [
                'success' => false,
                'message' => 'API error: HTTP ' . $httpCode
            ];
        }

        $result = json_decode($response, true);
        
        if (!$result) {
            log_message('error', 'AI API JSON Decode Error - Response: ' . $response);
            return [
                'success' => false,
                'message' => 'Invalid JSON response'
            ];
        }

        // Check for content in different possible fields
        $generatedText = '';
        
        if (isset($result['choices'][0]['message']['content']) && !empty($result['choices'][0]['message']['content'])) {
            $generatedText = trim($result['choices'][0]['message']['content']);
        } elseif (isset($result['choices'][0]['message']['reasoning']) && !empty($result['choices'][0]['message']['reasoning'])) {
            // Some models return text in reasoning field
            $generatedText = trim($result['choices'][0]['message']['reasoning']);
        } elseif (isset($result['choices'][0]['text']) && !empty($result['choices'][0]['text'])) {
            // Some models return text directly in choices
            $generatedText = trim($result['choices'][0]['text']);
        }
        
        if (empty($generatedText)) {
            log_message('error', 'AI API Missing Content - Result: ' . json_encode($result));
            
            // Fallback: generate simple text if API fails
            $fallbackText = $this->generateFallbackText($prompt);
            return [
                'success' => true,
                'text' => $fallbackText
            ];
        }

        log_message('info', 'AI API Success - Generated Text Length: ' . strlen($generatedText));

        return [
            'success' => true,
            'text' => $generatedText
        ];
    }
    
    private function generateFallbackText($prompt)
    {
        // Simple fallback text generation based on prompt content
        if (strpos($prompt, 'aktivitas') !== false) {
            return "Aktivitas ini merupakan kegiatan yang memberikan pengalaman berharga dan pembelajaran yang berguna untuk pengembangan diri. Melalui aktivitas ini, saya dapat mengembangkan berbagai keterampilan dan memperoleh wawasan baru yang bermanfaat.";
        } elseif (strpos($prompt, 'pelatihan') !== false) {
            return "Pelatihan ini memberikan pengetahuan dan keterampilan baru yang sangat bermanfaat untuk pengembangan karir. Materi yang diajarkan sangat relevan dengan kebutuhan industri saat ini dan dapat langsung diaplikasikan dalam pekerjaan.";
        } elseif (strpos($prompt, 'project') !== false) {
            return "Proyek ini dikembangkan dengan menggunakan teknologi terkini dan mengikuti best practices dalam pengembangan software. Proyek ini memiliki fitur-fitur yang user-friendly dan dapat memberikan solusi yang efektif untuk kebutuhan pengguna.";
        } elseif (strpos($prompt, 'organisasi') !== false) {
            return "Pengalaman berorganisasi ini memberikan kesempatan untuk mengembangkan kemampuan leadership, teamwork, dan komunikasi. Melalui berbagai kegiatan organisasi, saya dapat berkontribusi positif dan belajar bekerja sama dalam tim.";
        } elseif (strpos($prompt, 'sertifikat') !== false) {
            return "Sertifikat ini memvalidasi kompetensi dan pengetahuan yang telah diperoleh melalui proses pembelajaran dan evaluasi yang ketat. Sertifikat ini menunjukkan kemampuan dan kredibilitas dalam bidang yang relevan.";
        } else {
            return "Deskripsi ini menggambarkan pengalaman dan pembelajaran yang berharga dalam pengembangan karir dan personal. Melalui berbagai aktivitas dan kegiatan, dapat diperoleh wawasan dan keterampilan yang berguna untuk masa depan.";
        }
    }
}